%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Infinite Cylindrical Source (ICS): Man et al. (2010)                    %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_ICS(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
Dt = lm/Cm;             % thermal diffusivity [m2/s]
r = sqrt(x.^2+y.^2);    % radial distance [m]

% Temperature change
T = QL*(1/4/pi/lm)*...
    quadgk(@(f) (1/pi)*expint((r.^2+ro^2-2*r*ro*cos(f))/4/Dt/t),0,pi);

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 
